function [ok]=udpreset(skt)
%function [ok]=udpreset(skt)
% call reset on remote STM/PIC
%updated for octave 3-Feb-2018 - Ian Stothers
% updated to add reset over serial %  5-Jun-2023 - Ian Stothers
if (nargin==0)
   skt='192.168.1.4';
   nargin=1;
endif
if (ischar(skt)==1)
   skt=sktopen(skt);
endif
if (isfield(skt,'ser')==1)
  [ok]=serreset(skt);
  return;
end
pbuf=uint8([13 0 0 0]);
rx_timeout=0.00;
retryp=10;
b=[];
ok=0;
while (retryp>0)
  flushinput(skt.udp);
  write(skt.udp,pbuf,skt.ip,skt.port);
  flushoutput(skt.udp);

%  pause(rx_timeout);
  b=read(skt.udp,8);
  if (max(size(b))<4)
   retryp=retryp-1;
  else
   if ((b(1)==14)&&(b(2)==0)&&(b(3)==0)&&(b(4)==0))
    ok=1;
    retryp=0;
   end
  end
endwhile

endfunction

function [ok]=serreset(skt)
   %function [ok]=serreset(skt)
%  5-Jun-2023 - Ian Stothers
if (ischar(skt)==1)
   skt=sersktopen(skt);
endif
pp_commands;
pbuf=uint8([UDP_RESET 0]);
ok=0;
sersendget(skt,pbuf,0);
endfunction

